//___________________________________
//                                   \
// PRECIPITATION Factory.  version 2.3
//___________________________________/


/*
 Make it snow, make it rain.

 Usage:

 Initialization code (load library and create a SnowFactory object):

   EvaluateScript("precipitation.js");
   var SnowField = new SnowFactory(100,  LoadImage("snowflake.png") ,true,1);
 
 Update code (add SnowField.UpdateAndDraw() to your renderscript):

   SetRenderScript("Render_Update()");
   function Render_Update()
   {
    SnowField.UpdateAndDraw();
   }

 If you want snow to start falling as soon as we enter the map,
 then put the following line in its Entry Script:

   SnowField.startSnowing();


 Known Bugs: 
	When walking down, snow decreases, patched with randomness.
	When changing maps, call startSnowing()/Raining() again or recalcOffset() 
	to make it snow/rain inside the screen. Also dont forget to set 
	.juststarted=false or it will look like it just starting precipitating.

*******************************************************************************
 Functions in this library:

SnowFactory(amount, flakeimage, juststarted, wind, dropspeed)
	Create a new SnowFactory object.
	amount: Amount of snowflakes
	flakeimage: an image
	juststarted: boolean. does it start snowing, or is it already snowing?
	wind: integer, -1 or 1 for slow wind, 10 is a storm. Makes the snow go diagonal.
	dropspeed: Amount of pixels the flake falls each FlipScreen(). Defaults to 1
	example:
		var SnowField = new SnowFactory(100,  LoadImage("snowflake.png") ,true,1);

startSnowing()
	Start snowing. (And starts using lots of CPU power ^_^ ) 
	example:
		SnowField.startSnowing();

isSnowing()
	Boolean. Returns true if it is snowing (snowflakes are active)
	example:
		if (SnowField.isSnowing()) {}
	You can use also 
		if (SnowField.snowing) {}

isFlaking()
	Boolean. Returns true if new snowflakes are being generated.
	example:
		if (SnowField.isFlaking()) {}

stopSnowing()
	It abruptly stops snowing.
	example:
		SnowField.stopSnowing();

stopFlaking()
	No new snowflakes will be generated. It will take a while until
	isSnowing() is false.
	example:
		SnowField.stopFlaking();

setWind(wind)
	Set a new value for wind (can be called while its snowing)

rand
	Variable that makes the flakes fall down in a non straight line. Defaults to 3.

*******************************************************************************

RainFactory(amount, splashsprite, splashdirection, juststarted, wind,
				dropspeed, droplength, raincolor, thunder_probability, thundercolor)
	Create a new SnowFactory object.
	amount: Amount of raindrops
	splashsprite: the name of an rss file with a splash. 
			Put 0 if you dont want to use it.
	juststarted: boolean. does it start raining, or is it already raining? 
			Splashes arent created right away. The fx is not very visible.
	wind: integer, -1 or 1 for slow wind, 10 is a storm. Makes the rain go diagonal.
	dropspeed: Amount of pixels the rain falls each FlipScreen(). Defaults to 8
	droplength: Length of the line representing a falling raindrop. 40 is the default value. 
	raincolor: enter a color here. Put numerical 0 here if you want the default.
	thunder_probability: Very ugly. 0 is recommended, else a very small number, like 0.007
			(no sound though, maybe if someone added real thunder...)
	thundercolor: The color the screen will turn to when thundering. Dont define if you want the default.

	example:
		var RainField = new RainFactory(50,"rainfx.rss","splash",true,-2,8,40,0,.002);

startRaining()
	Start raining. (And starts using lots of CPU power ^_^ ) 
	example:
		RainField.startRaining();

isRaining()
	Boolean. Returns true if it is raining (raindrops are active)
	example:
		if (RainField.isRaining()) {}

isDropping()
	Boolean. Returns true if new raindrops are being generated.
	example:
		if (RainField.isDropping()) {}

stopRaining()
	It abruptly stops raining.
	example:
		RainField.stopRaining();

stopDropping()
	No new raindrops will be generated. It will take a little while until
	isRaining() is false.
	example:
		RainField.stopDropping();

setWind(wind)
	Set a new value for wind (can be called while its raining)

setDropspeed(dropspeed)
	Set a new value for dropspeed (can be called while its raining)

*******************************************************************************

UpdateAndDraw()
	Renders the snow/rain to the Screen. Put this command inside a render script.
	The mapengine must be running when you call this command.
	It is very efficient when its not (snow/rain)ing, so dont do:
	if (RainField.isRaining()) {RainField.UpdateAndDraw()} // BAD! DONT!
	examples:
		SnowField.UpdateAndDraw();
		RainField.UpdateAndDraw();

	Dont call .run() yourself, use .UpdateAndDraw() inside a RenderScript.
*/
//----------------------------------------------------------------------------//

function SnowFactory(amount,flakeimage,juststarted,wind,dropspeed)
{
	if (this instanceof SnowFactory == false)
		return new SnowFactory(mount,flakeimage,juststarted,wind,dropspeed);

	this.flake = flakeimage||Abort("precipitation.js: function SnowFactory: a flake image is required.");
	this.snowing = false;
	this.moreflakes = false;
	this.juststarted= juststarted;
	this.offsetX = undefined;
	this.offsetY = undefined;
	this.GSW = GetScreenWidth();
	this.GSH = GetScreenHeight();
	this.GSH80 = this.GSH+80;
	this.GSH100 = this.GSH+120;
	this.dropspeed = dropspeed||1;
	this.wind = (wind||0) - 1;
	this.rand = 3;
	this.UpdateAndDraw = function(){};

	this.flakes = new Array(amount);
	for (var i=0;i<this.flakes.length;++i) {
		this.flakes[i] = {x:Math.floor(Math.random()*this.GSW), y:Math.floor(Math.random()*this.GSH)-5, h:10+Math.floor(Math.random()*this.GSH), w:1};
		if (juststarted)
			this.flakes[i].y=this.GSH+5;
	}
}
//----------------------------------------------------------------------------//
function RainFactory(amount,splashsprite,splashdirection,juststarted,wind,dropspeed,droplength,raincolor,thunder_probability,thundercolor)
{
	if (this instanceof RainFactory == false)
		return new RainFactory(amount,splashsprite,splashdirection,juststarted,wind,dropspeed,droplength,raincolor,thunder_probability,thundercolor);

	this.raining = false;
	this.moredrops = false;
	this.juststarted = juststarted;
	this.offsetX = undefined;
	this.offsetY = undefined;
	this.GSW = GetScreenWidth();
	this.GSH = GetScreenHeight();
	this.GSH80 = this.GSH+80;
	this.GSH100 = this.GSH+120;
	this.thunder_probability = thunder_probability||0;
	this.dropspeed = dropspeed||8;
	this.wind = wind||0;
	var theta = (wind)? Math.atan(this.dropspeed/wind):Math.PI/2;
	this.droplength = droplength || 40; 
	this.lx = -Math.floor(Math.cos(theta)*this.droplength); //deltaLength rain line(x1,y1, x2,y2)).
	this.ly = -Math.floor(Math.sin(theta)*this.droplength);
	this.UpdateAndDraw = function(){};

	this.dosplash=false;
	if (typeof splashsprite=="string") {
		this.dosplash=true;
		this.splash= LoadSpriteset(splashsprite);
		for(var i=0;i<this.splash.directions.length;++i) {
			if (this.splash.directions[i].name==splashdirection) {
				this.splashframesMax=this.splash.directions[i].frames.length;
				this.splashimages=new Array(this.splashframesMax);
				for(var j=0;j<this.splashframesMax;++j)
					this.splashimages[j]= this.splash.images[this.splash.directions[i].frames[j].index];
			}
		}
	}
	this.raincolor = raincolor||CreateColor(200,230,250,100);
	this.thundercolor = thundercolor||raincolor||CreateColor(200,230,250,100);
	this.drops = new Array(amount);
	for (var i=0;i<this.drops.length;++i) {
		this.drops[i] = {x:Math.floor(Math.random()*this.GSW), y:Math.floor(Math.random()*this.GSH)-5, h:10+Math.floor(Math.random()*this.GSH), w:1};
		//if (juststarted) this.drops[i].y=this.GSH+5;
	}
}


//----------------------------------------------------------------------------//


SnowFactory.prototype.recalcOffset = function() { this.offsetX=MapToScreenX(0,0); this.offsetY=MapToScreenY(0,0); }
RainFactory.prototype.recalcOffset = function() { this.offsetX=MapToScreenX(0,0); this.offsetY=MapToScreenY(0,0); }

SnowFactory.prototype.isSnowing = function() { return this.snowing; }
RainFactory.prototype.isRaining = function() { return this.raining; }

SnowFactory.prototype.isFlaking = function() { return this.moreflakes; }
RainFactory.prototype.isDropping = function() {	return this.moredrops; }

SnowFactory.prototype.stopFlaking = function() { this.moreflakes=false; }
RainFactory.prototype.stopDropping = function() { this.moredrops=false; }

SnowFactory.prototype.stopSnowing = function() { this.snowing=false; this.stopFlaking(); this.UpdateAndDraw=function(){};}
RainFactory.prototype.stopRaining = function() { this.raining=false; this.stopDropping(); this.UpdateAndDraw=function(){};}

SnowFactory.prototype.startSnowing = function() {
	var Floor = Math.floor;
	var Random = Math.random;
	var i = this.flakes.length-1;
	do {
		var tfi = this.flakes[i];
		tfi.x = Floor(Random()*this.GSW);
		tfi.y = Floor(Random()*this.GSH)-5;
		tfi.h = 10+Floor(Random()*this.GSH);
		tfi.w = 1;
		if(this.juststarted) 
			tfi.y = this.GSH+5;
	} while(i--);
	this.moreflakes = true;
	this.snowing = true;
	this.offsetX = IsMapEngineRunning()? MapToScreenX(0,0):0;
	this.offsetY = IsMapEngineRunning()? MapToScreenY(0,0):0;
	this.UpdateAndDraw = this.run;
}

RainFactory.prototype.startRaining = function() {
	var Floor = Math.floor;
	var Random = Math.random;
	var i = this.drops.length-1;
	do {
		this.drops[i].x = Floor(Random()*this.GSW);
		this.drops[i].y = Floor(Random()*this.GSH);
		this.drops[i].h = Floor(Random()*this.GSH);
		this.drops[i].w = 1;
		this.drops[i].i = 0;
		if(this.juststarted)
			this.drops[i].y = -Floor(Random()*this.GSH);
	} while(i--);
	this.moredrops = true;
	this.raining = true;
	this.offsetX = IsMapEngineRunning()? MapToScreenX(0,0):0;
	this.offsetY = IsMapEngineRunning()? MapToScreenY(0,0):0;
	this.UpdateAndDraw = this.run;
}


//----------------------------------------------------------------------------//

SnowFactory.prototype.run = function()
{
  var INRS=true;
  var NewOffsetX=MapToScreenX(0,0)-this.offsetX;
  var NewOffsetY=MapToScreenY(0,0)-this.offsetY;
  this.offsetX+=NewOffsetX; 	
  this.offsetY+=NewOffsetY;
  var Floor=Math.floor;
  var Random=Math.random;
  var i=this.flakes.length-1;
  do
  {
    var tfi=this.flakes[i];
    --tfi.h; 
    if(tfi.h>0)
    { INRS=false;
      tfi.x=(tfi.x+NewOffsetX)%this.GSW;
      if(tfi.x<0) tfi.x+=this.GSW;
      if(NewOffsetY) tfi.y =(tfi.y+NewOffsetY)%(this.GSH80);
      if(tfi.h>100){
	tfi.x+=Floor(Random()*this.rand)+this.wind;
	tfi.y+=this.dropspeed;
      }
      this.flake.zoomBlit(tfi.x,tfi.y,.1+(tfi.h*0.00285));
    }
    else
    {
      if(this.moreflakes)
      {
	tfi.x=Floor(Random()*this.GSW);
	if(NewOffsetY<0)tfi.y=Floor(Random()*this.GSW)-5;
	else tfi.y=-5;
	tfi.h=Floor(Random()*this.GSH100);
      }
    }
  }while (i--);
  if(INRS)this.stopSnowing();
}

//----------------------------------------------------------------------------//


RainFactory.prototype.run = function()
{
  var INRS=true;
  var NewOffsetX=MapToScreenX(0,0)-this.offsetX;
  var NewOffsetY=MapToScreenY(0,0)-this.offsetY;
  this.offsetX+=NewOffsetX; 	
  this.offsetY+=NewOffsetY;
  var i=this.drops.length-1;
  do
  {
   var tdi=this.drops[i];
    tdi.h-=1;
    if(tdi.h>0)
    {INRS=false;
      if(tdi.h<100&&this.dosplash) {
	this.splashimages[tdi.i].blit(tdi.x,tdi.y);
    	if(++tdi.i==this.splashframesMax) tdi.h=0;
    	if(NewOffsetX) tdi.x=(tdi.x+NewOffsetX)%this.GSW;
    	if(tdi.x<0) tdi.x+=this.GSW;
    	if(NewOffsetY) tdi.y=(tdi.y+NewOffsetY)%(this.GSH);
      }
      else {
    	Line(tdi.x, tdi.y, tdi.x+this.lx, tdi.y+this.ly, this.raincolor);
	tdi.x=(tdi.x+this.wind+NewOffsetX)%this.GSW;
    	if(tdi.x<0) tdi.x+=this.GSW;
	tdi.y=(tdi.y+this.dropspeed+NewOffsetY)%(this.GSH);
      }
    }
    else 
    {
	var Floor=Math.floor;
	var Random=Math.random;
      if(this.moredrops) {
	tdi.y=Floor(Random()*this.GSH);
	tdi.h=Floor(Random()*this.GSH);
	tdi.i=0;
	if(this.thunder_probability&&(Random()<this.thunder_probability)) ApplyColorMask(this.thundercolor);
      }
      else tdi.h=0;
    }
  }while(i--);
  this.raining=!INRS;
  if(INRS)this.stopRaining();
}

RainFactory.prototype.setWind = function(wind) {
	this.wind = wind;
	var theta = (wind)? Math.atan(this.dropspeed/wind):Math.PI/2;
	this.lx = -Math.floor(Math.cos(theta)*this.droplength); //deltaLength rain line(x1,y1, x2,y2)).
	this.ly = -Math.floor(Math.sin(theta)*this.droplength);
}
SnowFactory.prototype.setWind = function(wind) { this.wind = wind; }
